/**
* \file: UspiInputSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Android Auto input component using USPI backend.
*
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_USPI_INPUTSOURCE_H
#define AAUTO_USPI_INPUTSOURCE_H

#include <aauto/AditInputSource.h>

namespace adit { namespace aauto {

class UspiInputSourceImpl;

/** @class  UspiInputSource
 *  @brief  Android Auto input backend using USPI Touch Backend
 */
class UspiInputSource : public AditInputSource
{
public:
    /** @brief  constructor
     *  @param  inSessionId: session ID used in GalReceiver
     *  @param  inMessageRouter: message router obtained from GalReceiver
     */
    UspiInputSource(uint8_t inSessionId, MessageRouter* inMessageRouter);

    virtual ~UspiInputSource();

    /** @brief  initialize and set configured parameters to USPI interface
     *  @return true on success, false on failure
     **/
    bool init();
    /** @brief  shutdown
    *   @return true on success, false on failure
    */
    bool shutdown();

    /** @brief  configure the necessary items specific to the underlying technology
     *  @param  inKey: key to define the configuration item
     *  @param  inValue: value to set to the configuration item
     */
    void setConfigItem(string inKey, string inValue);

    /** @brief  register callbacks to receive input related notifications.
     *  @param  inCallbacks callback implementation
     */
    void registerCallbacks(IAditInputSourceCallbacks* inCallbacks);

private:
    UspiInputSourceImpl *impl;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_USPI_INPUTSOURCE_H */
